/* 
 *  ClientEventTask.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.api.ClientI;
import com.avaya.ccs.api.enums.NotificationType;    
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;

/**
 * This class is used to process client event. The processing of the event may
 * drive: 1) a GUI update 2) further calls back into the SDK
 */
public class ClientEventTask extends Task<ClientData> {

    private final NotificationType type;
    private final ClientI client;
    private final JavaFXRefClient gui;

    private static final Logger LOG = Logger.getLogger(ClientEventTask.class);

    public ClientEventTask(NotificationType type, ClientI client, JavaFXRefClient gui) {
        this.type = type;
        this.client = client;
        this.gui = gui;

        setupJavaFXApplicationHandlers();
    }

    private void setupJavaFXApplicationHandlers() {
        setupJavaFXApplicationSucceededHandler();
        setupJavaFXApplicationFailureHandler();
    }

    private void setupJavaFXApplicationSucceededHandler() {
        this.setOnSucceeded((WorkerStateEvent t) -> {
            String methodName = "succeededHandler() ";
            ClientData value = (ClientData) t.getSource().valueProperty().getValue();
            if (value != null) {
                LOG.info(methodName + "ClientData:" + value);
                gui.updateClientData(value);
            } else {
                LOG.debug(methodName + " NULL");
            }
        });
    }

    private void setupJavaFXApplicationFailureHandler() {
        /**
         * The failure handler will be executed if an exception is thrown from
         * within the executing task, ie from within the call method below
         */
        this.setOnFailed((WorkerStateEvent t) -> {
            String methodName = "failedHandler() ";
            LOG.trace(methodName);
        });
    }

    /**
     * The call method executes on the incomingEvent thread
     *
     * @return
     * @throws Exception
     */
    @Override
    protected ClientData call() throws Exception {
        String methodName = "call() ";
        LOG.debug(methodName + "Type:" + type);
        switch (type) {
        case UPDATE:
            break;
        case DELETE:
            break;
        case ERROR:
            break;
        case NEW:
            break;
        case RESPONSE:
            break;
        case UNKNOWN:
            break;
        }
        ClientData data = new ClientData(client);
        return data;
    }
}
